% Load dataset
load('digits.mat');

% Train a model with a smoothing parameter
tau = 0.01;
model = naiveBayesTrain(data.train.x, data.train.y, tau);

% Make predictions on the validation data
ypredVal = naiveBayesPredict(model, data.val.x);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('NaiveBayes:: Validation accuracy: %.2f%%\n',  accVal*100);

% Make predictions on the test data
ypredTest = naiveBayesPredict(model, data.test.x);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest, true);
fprintf('NaiveBayes:: Test accuracy: %.2f%%\n',  accTest*100);