%% Load dataset
load('digits.mat');

% Visualize the digits in the training set
%montageDigits(data.train.x);

% Set parameters for learning
param.kernel.type = 'linear'; % or 'poly'

% Paramters for various kernels
param.kernel.poly.a = 1;
param.kernel.poly.b = 1;
param.kernel.poly.d = 4;

% Other parameters 
param.maxiter = 100;

%% :-------------------------------------------------------------------: %%
%%%%%%%%%%%%%%%%%     This is for Problem 1 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
param.kernel.type = 'linear';

% Train onevsall classifier
param.type = 'onevsall';
model = multiclassTrain(data.train.x, data.train.y, param);

% Make predictions on validation set
ypredVal = multiclassPredict(model, data.val.x, param);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('OneVsAll:: Perceptron (%s):: Validation accuracy: %.2f%%\n',param.kernel.type, accVal*100);

% Make predictions on test set
ypredTest = multiclassPredict(model, data.test.x, param);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest);
fprintf('OneVsAll:: Perceptron (%s):: Test accuracy: %.2f%%\n', param.kernel.type,accTest*100);

% Train onevsone classifier
param.type = 'onevsone';
model = multiclassTrain(data.train.x, data.train.y, param);

% Make predictions on validation set
ypredVal = multiclassPredict(model, data.val.x, param);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('OneVsOne:: Perceptron (%s):: Validation accuracy: %.2f%%\n',param.kernel.type,accVal*100);

% Make predictions on test set
ypredTest = multiclassPredict(model, data.test.x, param);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest);
fprintf('OneVsOne:: Perceptron (%s):: Test accuracy: %.2f%%\n',param.kernel.type,accTest*100);


%% :-------------------------------------------------------------------: %%
%%%%%%%%%%%%%%%%%     This is for Problem 2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

param.kernel.type = 'poly';

% Train onevsall classifier with polynomial kernel
param.type = 'onevsall';
model = multiclassTrain(data.train.x, data.train.y, param);

% Make predictions on validation set
ypredVal = multiclassPredict(model, data.val.x, param);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('OneVsAll:: Perceptron (%s):: Validation accuracy: %.2f%%\n',param.kernel.type,accVal*100);

% Make predictions on test set
ypredTest = multiclassPredict(model, data.test.x, param);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest);
fprintf('OneVsAll:: Perceptron (%s):: Test accuracy: %.2f%%\n',param.kernel.type, accTest*100);

% Train onevsone classifier with polynomial kernel
param.type = 'onevsone';
model = multiclassTrain(data.train.x, data.train.y, param);

% Make predictions on validation set
ypredVal = multiclassPredict(model, data.val.x, param);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('OneVsOne:: Perceptron (%s):: Validation accuracy: %.2f%%\n',param.kernel.type,accVal*100);

% Make predictions on test set
ypredTest = multiclassPredict(model, data.test.x, param);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest);
fprintf('OneVsOne:: Perceptron (%s):: Test accuracy: %.2f%%\n',param.kernel.type,accTest*100);
