% Load dataset
load('digits.mat');

% Learning parameters
param.lambda = 0.01;
param.eta = 0.001;
param.maxiter = 1000;
param.numUnits = 100;

% Train model
model = multiclassNNTrain(data.train.x, data.train.y, param);

% Make predictions on the validation data
ypredVal = multiclassNNPredict(model, data.val.x);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('Multiclass LR:: Validation accuracy: %.2f%%\n',  accVal*100);

% Make predictions on the test data
ypredTest = multiclassNNPredict(model, data.test.x);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest, true);
fprintf('Multiclass LR:: Test accuracy: %.2f%%\n',  accTest*100);