% Load dataset
load('digits.mat');

% Learning parameters
param.lambda = 0.01;
param.eta = 0.01;
param.maxiter = 100;

% Train model
model = multiclassLRTrain(data.train.x, data.train.y, param);

% Make predictions on the validation data
ypredVal = multiclassLRPredict(model, data.val.x);
[accVal, confVal] = evaluateLabels(data.val.y, ypredVal);
fprintf('Multiclass LR:: Validation accuracy: %.2f%%\n',  accVal*100);

% Make predictions on the test data
ypredTest = multiclassLRPredict(model, data.test.x);
[accTest, confTest] = evaluateLabels(data.test.y, ypredTest, true);
fprintf('Multiclass LR:: Test accuracy: %.2f%%\n',  accTest*100);