function model = averagedPerceptronTrain(x, y, param)
featDim = size(x, 1);
numData = size(x, 2);
assert(size(y,2) == numData);
wbar = zeros(featDim,1);
w = zeros(featDim,1);
c = 0;

% iterate over data
totalMistakes = 0;
for iter = 1:param.maxiter, 
    iterMistakes = 0;
    for i = 1:numData,
        xi = x(:,i);
        yi = y(i);
        yp = 2*(w'*xi > 0)-1;
        if yp ~= yi,
            wbar = wbar + c*w;
            w = w + yi*xi;
            iterMistakes = iterMistakes + 1;
            c = 1;
        else
            c = c+1;
        end
    end
    totalMistakes = totalMistakes + iterMistakes;
    if iterMistakes == 0, % Early termination
        break;
    end
end
wbar = wbar + c*w;
model.w = wbar;
yp = perceptronPredict(model, x);
fprintf('Training error: %i/%i\n', sum(yp~=y), numData);
model.totalMistakes = totalMistakes;